/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.quad.properties;

import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;

public enum ModelQuadOrientation {
    NORMAL(new int[]{0, 1, 2, 3}),
    FLIP(new int[]{1, 2, 3, 0});

    private final int[] indices;

    private ModelQuadOrientation(int[] indices) {
        this.indices = indices;
    }

    public int getVertexIndex(int idx) {
        return this.indices[idx];
    }

    public static ModelQuadOrientation orientByBrightness(float[] brightnesses, int[] lightmaps) {
        float br02 = brightnesses[0] + brightnesses[2];
        float br13 = brightnesses[1] + brightnesses[3];
        if (br02 > br13) {
            return NORMAL;
        }
        if (br02 < br13) {
            return FLIP;
        }
        int lm02 = lightmaps[0] + lightmaps[2];
        int lm13 = lightmaps[1] + lightmaps[3];
        if (lm02 <= lm13) {
            return NORMAL;
        }
        return FLIP;
    }

    public static ModelQuadOrientation orientByBrightness(float[] brightnesses, ModelQuadView quad) {
        int lm13;
        float br02 = brightnesses[0] + brightnesses[2];
        float br13 = brightnesses[1] + brightnesses[3];
        if (br02 > br13) {
            return NORMAL;
        }
        if (br02 < br13) {
            return FLIP;
        }
        int lm02 = quad.getLight(0) + quad.getLight(2);
        if (lm02 <= (lm13 = quad.getLight(1) + quad.getLight(3))) {
            return NORMAL;
        }
        return FLIP;
    }
}

