/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.value;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.client.config.structure.Config;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.minecraft.class_2960;

public class DynamicValue<V>
implements DependentValue<V>,
ConfigState {
    private final Set<class_2960> dependencies;
    private class_2960 parentOption = null;
    private final Function<ConfigState, V> provider;
    private Config state;
    private V valueCache;

    public DynamicValue(Function<ConfigState, V> provider, class_2960[] dependencies) {
        this.provider = provider;
        this.dependencies = Set.of(dependencies);
    }

    @Override
    public V get(Config state) {
        if (this.valueCache != null) {
            return this.valueCache;
        }
        this.state = state;
        this.valueCache = this.provider.apply(this);
        this.state = null;
        return this.valueCache;
    }

    @Override
    public Collection<class_2960> getDependencies() {
        return this.dependencies;
    }

    public void allowReadingParentOption(class_2960 id) {
        this.parentOption = id;
    }

    public void invalidateCache() {
        this.valueCache = null;
    }

    private boolean getReadType(class_2960 id) {
        if (!this.dependencies.contains(id)) {
            if (id.equals((Object)this.parentOption)) {
                return true;
            }
            throw new IllegalStateException("Attempted to read option value that is not a declared dependency");
        }
        return false;
    }

    @Override
    public boolean readBooleanOption(class_2960 id) {
        boolean readType = this.getReadType(id);
        return this.state.readBooleanOption(id, readType);
    }

    @Override
    public int readIntOption(class_2960 id) {
        boolean readType = this.getReadType(id);
        return this.state.readIntOption(id, readType);
    }

    @Override
    public <E extends Enum<E>> E readEnumOption(class_2960 id, Class<E> enumClass) {
        boolean readType = this.getReadType(id);
        return this.state.readEnumOption(id, enumClass, readType);
    }
}

