/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinTool;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolPixelSelection
extends ETFScreenOldCompat {
    private final SelectionMode MODE;
    private final ETFConfigScreenSkinTool etfParent;
    Set<Integer> selectedPixels;
    class_2960 currentSkinToRender = ETFUtils2.res("entity_texture_features:textures/gui/icon.png");

    protected ETFConfigScreenSkinToolPixelSelection(ETFConfigScreenSkinTool parent, SelectionMode mode) {
        super("config.entity_texture_features" + (mode == SelectionMode.EMISSIVE ? ".emissive_select" : ".enchanted_select") + ".title", parent, false);
        this.MODE = mode;
        this.etfParent = parent;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        class_2960 randomID = ETFUtils2.res("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
        if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID)) {
            this.currentSkinToRender = randomID;
        }
        this.selectedPixels = new HashSet<Integer>();
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                int color = ETFUtils2.getPixel(this.etfParent.currentEditorSkin, x, y);
                if (color == 0) continue;
                this.selectedPixels.add(color);
            }
        }
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.024), (int)((double)this.field_22790 * 0.2), 20, 20, class_2561.method_30163((String)"\u27f3"), button -> {
            this.etfParent.flipView = !this.etfParent.flipView;
        }));
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.55), (int)((double)this.field_22790 * 0.9), (int)((double)this.field_22789 * 0.2), 20, class_5244.field_24339, button -> Objects.requireNonNull(this.field_22787).method_1507(this.parent)));
        int pixelSize = (int)((double)this.field_22790 * 0.7 / 64.0);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                class_4185 butt = this.getButtonPixels(x, y, pixelSize);
                this.method_37063((class_364)butt);
            }
        }
    }

    @NotNull
    private class_4185 getButtonPixels(int x, int y, int pixelSize) {
        return new class_4185.class_12231(this, (int)((double)this.field_22789 * 0.35 + (double)(x * pixelSize)), (int)((double)this.field_22790 * 0.2 + (double)(y * pixelSize)), pixelSize, pixelSize, class_2561.method_30163((String)""), button -> {
            int colorAtPixel = ETFUtils2.getPixel(this.etfParent.currentEditorSkin, x, y);
            if (this.selectedPixels.contains(colorAtPixel)) {
                this.selectedPixels.remove(colorAtPixel);
            } else {
                this.selectedPixels.add(colorAtPixel);
            }
            this.applyCurrentSelectedPixels();
            this.etfParent.thisETFPlayerTexture.changeSkinToThisForTool(this.etfParent.currentEditorSkin);
            class_2960 randomID2 = ETFUtils2.res("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
            if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID2)) {
                this.currentSkinToRender = randomID2;
            }
        }, Supplier::get){

            protected void method_75752(class_332 guiGraphics, int i, int j, float f) {
            }
        };
    }

    private void applyCurrentSelectedPixels() {
        ArrayList<Integer> integerSet = new ArrayList<Integer>(this.selectedPixels);
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                if (integerSet.isEmpty()) {
                    ETFUtils2.setPixel(this.etfParent.currentEditorSkin, x, y, 0);
                    continue;
                }
                ETFUtils2.setPixel(this.etfParent.currentEditorSkin, x, y, integerSet.get(0));
                integerSet.remove(0);
            }
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int pixelSize = (int)((double)this.field_22790 * 0.7 / 64.0);
        ETFConfigScreenSkinToolPixelSelection.renderGUITexture(context, this.currentSkinToRender, (int)((double)this.field_22789 * 0.35), (int)((double)this.field_22790 * 0.2), (int)((double)this.field_22789 * 0.35 + (double)(64 * pixelSize)), (int)((double)this.field_22790 * 0.2 + (double)(64 * pixelSize)));
        context.method_27535(this.field_22793, ETF.getTextFromTranslation("config.entity_texture_features.skin_select" + (this.selectedPixels.size() > 64 ? ".warn" : ".hint")), this.field_22789 / 7, (int)((double)this.field_22790 * 0.8), this.selectedPixels.size() > 64 ? 0xFF1515 : 0xFFFFFF);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            int height = (int)((double)this.field_22790 * 0.75);
            int playerX = (int)((double)this.field_22789 * 0.14);
            this.drawEntity(context, playerX, height, (int)((double)this.field_22790 * 0.3), mouseX, mouseY, (class_1309)player);
        } else {
            context.method_27535(this.field_22793, class_2561.method_30163((String)"Player model only visible while in game!"), this.field_22789 / 7, (int)((double)this.field_22790 * 0.4), 0xFFFFFF);
            context.method_27535(this.field_22793, class_2561.method_30163((String)"load a single-player world and then open this menu."), this.field_22789 / 7, (int)((double)this.field_22790 * 0.45), 0xFFFFFF);
        }
    }

    public void drawEntity(class_332 context, int x, int y, int size, float mouseX, float mouseY, class_1309 entity) {
        ETFConfigScreenSkinTool.renderEntityInInventoryFollowsMouse(this.etfParent.flipView, context, 0, (int)((double)this.field_22790 * 0.15), x * 2, y, size, 0.0625f, mouseX + (float)((int)((double)this.field_22790 * 0.15)), mouseY, entity);
    }

    public static enum SelectionMode {
        EMISSIVE(56, 16),
        ENCHANTED(56, 24);

        final int startX;
        final int startY;

        private SelectionMode(int start_x, int start_y) {
            this.startX = start_x;
            this.startY = start_y;
        }
    }
}

