/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.data.NamedReloadListener;
import einstein.subtle_effects.data.SparkProviderData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6880;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SparkProviderReloadListener
extends class_4309<SparkProviderData>
implements NamedReloadListener {
    public static final class_7654 DIRECTORY = class_7654.method_45114((String)"subtle_effects/spark_providers");
    public static final Map<class_2248, List<SparkProvider>> PROVIDERS = new HashMap<class_2248, List<SparkProvider>>();

    public SparkProviderReloadListener() {
        super(SparkProviderData.CODEC, DIRECTORY);
    }

    protected void apply(Map<class_2960, SparkProviderData> resources, class_3300 manager, class_3695 filler) {
        PROVIDERS.clear();
        SparkProviderReloadListener.load(resources);
    }

    private static void load(Map<class_2960, SparkProviderData> resources) {
        resources.forEach((location, providerData) -> {
            Optional<SparkProviderData.Options> providerOptions = providerData.options();
            if (providerOptions.isEmpty()) {
                return;
            }
            SparkProviderData.Options options = providerOptions.get();
            providerData.states().forEach(providerEntry -> {
                class_2960 blockId = providerEntry.id();
                boolean isRequired = providerEntry.required();
                boolean isRegistered = class_7923.field_41175.method_10250(blockId);
                if (isRequired && !isRegistered) {
                    SubtleEffects.LOGGER.warn("Could not find required block for states '{}' in Spark Provider: '{}'", (Object)blockId, location);
                    return;
                }
                if (isRequired || isRegistered) {
                    class_2248 block = (class_2248)((class_6880.class_6883)class_7923.field_41175.method_10223(blockId).get()).comp_349();
                    if (block.method_9564().method_26215()) {
                        SubtleEffects.LOGGER.error("Block in Spark Provider '{}' can not be air", location);
                    }
                    class_2689 definition = block.method_9595();
                    BlockStateHolder stateHolder = new BlockStateHolder(block, isRequired, providerEntry.properties().entrySet().stream().map(entry -> SparkProviderReloadListener.convertToProperties(entry, definition.method_11663((String)entry.getKey()))).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c1, c2) -> c1)));
                    if (PROVIDERS.containsKey(block)) {
                        PROVIDERS.get(block).add(new SparkProvider(stateHolder, options));
                        return;
                    }
                    ArrayList<SparkProvider> providers = new ArrayList<SparkProvider>();
                    providers.add(new SparkProvider(stateHolder, options));
                    PROVIDERS.put(block, providers);
                }
            });
        });
    }

    @Nullable
    private static <T extends Comparable<T>> Map.Entry<class_2769<T>, Comparable<T>> convertToProperties(Map.Entry<String, String> entry, @Nullable class_2769<T> property) {
        String propertyName = entry.getKey();
        String valueName = entry.getValue();
        if (property != null) {
            Optional value = property.method_11900(valueName);
            if (value.isPresent()) {
                return Map.entry(property, (Comparable)value.get());
            }
            SubtleEffects.LOGGER.error("Unknown value '{}' for blockstate property '{}' in Spark Provider. Possible values for property {}", new Object[]{valueName, propertyName, property.method_11898()});
            return null;
        }
        SubtleEffects.LOGGER.error("Unknown blockstate property '{}' for Spark Provider", (Object)propertyName);
        return null;
    }

    @Override
    public class_2960 getId() {
        return SubtleEffects.loc("spark_providers");
    }

    public record BlockStateHolder(class_2248 block, boolean required, Map<class_2769<?>, Comparable<?>> properties) {
        public boolean matches(@Nullable class_2680 state) {
            if (state != null && state.method_27852(this.block)) {
                for (Map.Entry<class_2769<?>, Comparable<?>> entry : this.properties.entrySet()) {
                    if (Objects.equals(state.method_11654(entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public record SparkProvider(BlockStateHolder stateHolder, SparkProviderData.Options options) {
    }
}

