/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer;

import einstein.subtle_effects.SubtleEffectsClient;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.mixin.client.particle.ParticleEngineAccessor;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import einstein.subtle_effects.util.SingleQuadParticleAccessor;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11658;
import net.minecraft.class_12179;
import net.minecraft.class_12180;
import net.minecraft.class_156;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import org.jetbrains.annotations.Nullable;

public class ParticleBoundingBoxesRenderer {
    private static final Map<class_3940.class_11941, Integer> LAYER_TO_COLOR = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_3940.class_11941.field_62639, -16711936);
        map.put(class_3940.class_11941.field_62640, -256);
        map.put(class_3940.class_11941.field_62641, -16711681);
    });

    private static Integer stringToColor(String color) {
        return color.hashCode();
    }

    public static void extractParticleBoundingBoxes(class_11658 levelRenderState, class_4184 camera, class_4604 frustum) {
        if (SubtleEffectsClient.DISPLAY_PARTICLE_BOUNDING_BOXES) {
            class_243 cameraPos = camera.method_71156();
            class_310 minecraft = class_310.method_1551();
            ArrayList renderStates = new ArrayList();
            float partialTicks = Util.getPartialTicks();
            class_4604 particleFrustum = frustum.method_74403(-3.0f);
            ((ParticleEngineAccessor)minecraft.field_1713).getParticles().forEach((renderType, particleGroup) -> {
                if (particleGroup == null || particleGroup.method_74284()) {
                    return;
                }
                Integer renderTypeColor = ParticleBoundingBoxesRenderer.stringToColor(renderType.comp_3340());
                particleGroup.method_74290().forEach(particle -> {
                    class_238 aabb = particle.method_3064();
                    if (particleFrustum.method_23093(aabb)) {
                        ParticleAccessor accessor = (ParticleAccessor)particle;
                        double x = class_3532.method_16436((double)partialTicks, (double)accessor.getOldX(), (double)accessor.getX()) - cameraPos.method_10216();
                        double y = class_3532.method_16436((double)partialTicks, (double)accessor.getOldY(), (double)accessor.getY()) - cameraPos.method_10214();
                        double z = class_3532.method_16436((double)partialTicks, (double)accessor.getOldZ(), (double)accessor.getZ()) - cameraPos.method_10215();
                        Integer color = renderTypeColor;
                        if (particle instanceof SingleQuadParticleAccessor) {
                            SingleQuadParticleAccessor quadAccessor = (SingleQuadParticleAccessor)particle;
                            color = LAYER_TO_COLOR.get(quadAccessor.subtleEffects$getLayer());
                        }
                        class_238 renderTypeAABB = new class_238(aabb.field_1323, aabb.field_1325 - 0.02, aabb.field_1321, aabb.field_1320, aabb.field_1325 + 0.02, aabb.field_1324);
                        renderStates.add(new ParticleBoundingBoxRenderState(x, y, z, color, aabb, renderTypeAABB));
                    }
                });
            });
            if (!renderStates.isEmpty()) {
                ((RenderStateAttachmentAccessor)levelRenderState).subtleEffects$set(ModRenderStateAttachmentKeys.PARTICLE_BOUNDING_BOXES, renderStates);
            }
        }
    }

    public static void renderParticleBoundingBoxes(class_4587 poseStack, class_11658 levelRenderState) {
        if (SubtleEffectsClient.DISPLAY_PARTICLE_BOUNDING_BOXES) {
            List<ParticleBoundingBoxRenderState> renderStates = ((RenderStateAttachmentAccessor)levelRenderState).subtleEffects$get(ModRenderStateAttachmentKeys.PARTICLE_BOUNDING_BOXES);
            if (renderStates == null) {
                return;
            }
            renderStates.forEach(renderState -> {
                class_12180.method_75541((class_238)renderState.aabb(), (class_12179)class_12179.method_75535((int)-1));
                Integer color = renderState.color();
                if (color != null) {
                    class_12180.method_75541((class_238)renderState.renderTypeAABB(), (class_12179)class_12179.method_75535((int)color));
                }
            });
        }
    }

    public record ParticleBoundingBoxRenderState(double x, double y, double z, @Nullable Integer color, class_238 aabb, class_238 renderTypeAABB) {
    }
}

