/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.geo;

import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.geo.NormalPlaneF;
import team.creative.creativecore.common.util.math.geo.Ray3d;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.math.vec.VectorUtils;

public class NormalPlaneD {
    public final Vec3d normal;
    public final Vec3d origin;

    public NormalPlaneD(Vec3d origin, Vec3d normal) {
        this.origin = origin;
        this.normal = new Vec3d(normal);
        this.normal.normalize();
    }

    public NormalPlaneD(Vec3f origin, Vec3f normal) {
        this.origin = new Vec3d(origin);
        this.normal = new Vec3d(normal);
        this.normal.normalize();
    }

    public NormalPlaneD(Facing facing) {
        this.origin = new Vec3d();
        this.normal = new Vec3d();
        this.normal.set(facing.axis, (double)facing.offset());
    }

    public NormalPlaneD(Axis axis, double value, Facing facing) {
        this.origin = new Vec3d();
        this.origin.set(axis, value);
        this.normal = new Vec3d();
        this.normal.set(facing.axis, (double)facing.offset());
    }

    public boolean isInvalid() {
        return Double.isNaN(this.normal.x) || Double.isNaN(this.normal.y) || Double.isNaN(this.normal.z);
    }

    public Boolean isInFront(Vec3d vec) {
        return this.isInFront(vec, 1.0E-7);
    }

    public Boolean isInFront(Vec3d vec, double epsilon) {
        Vec3d temp = new Vec3d(vec);
        temp.sub(this.origin);
        double result = this.normal.dot(temp);
        if (result < 0.0 ? result > -epsilon : result < epsilon) {
            return null;
        }
        return result > 0.0;
    }

    public Boolean isInFront(Vec3f vec) {
        return this.isInFront(vec, 1.0E-4f);
    }

    public Boolean isInFront(Vec3f vec, float epsilon) {
        Vec3d temp = new Vec3d(vec);
        temp.sub(this.origin);
        double result = this.normal.dot(temp);
        if (result < 0.0 ? result > (double)(-epsilon) : result < (double)epsilon) {
            return null;
        }
        return result > 0.0;
    }

    public boolean cuts(VectorFan strip) {
        boolean front = false;
        boolean back = false;
        for (int i = 0; i < strip.count(); ++i) {
            Boolean result = this.isInFront(strip.get(i));
            if (result == null) {
                return true;
            }
            if (result.booleanValue()) {
                front = true;
            }
            if (!result.booleanValue()) {
                back = true;
            }
            if (!front || !back) continue;
            return true;
        }
        return false;
    }

    public Vec3d intersect(Vec3d start, Vec3d end) {
        Vec3d lineOrigin = start;
        Vec3d lineDirection = new Vec3d(end);
        lineDirection.sub(lineOrigin);
        lineDirection.normalize();
        if (VectorUtils.isZero(this.normal.dot(lineDirection))) {
            return null;
        }
        double t = (this.normal.dot(this.origin) - this.normal.dot(lineOrigin)) / this.normal.dot(lineDirection);
        Vec3d point = new Vec3d(lineDirection);
        point.scale(t);
        point.add(lineOrigin);
        return point;
    }

    public Vec3d intersect(Ray3d ray) {
        if (VectorUtils.isZero(this.normal.dot(ray.direction))) {
            return null;
        }
        double t = (this.normal.dot(this.origin) - this.normal.dot(ray.origin)) / this.normal.dot(ray.direction);
        Vec3d point = new Vec3d(ray.direction);
        point.scale(t);
        point.add(ray.origin);
        return point;
    }

    public Double project(Axis one, Axis two, Axis axis, double valueOne, double valueTwo) {
        Vec3d lineOrigin = new Vec3d();
        lineOrigin.set(one, valueOne);
        lineOrigin.set(two, valueTwo);
        Vec3d lineDirection = new Vec3d();
        lineDirection.set(axis, 1.0);
        if (VectorUtils.isZero(this.normal.dot(lineDirection))) {
            return null;
        }
        double t = (this.normal.dot(this.origin) - this.normal.dot(lineOrigin)) / this.normal.dot(lineDirection);
        return lineOrigin.get(axis) + lineDirection.get(axis) * t;
    }

    public String toString() {
        return "[o:" + String.valueOf(this.origin) + ",n:" + String.valueOf(this.normal) + "]";
    }

    public NormalPlaneF toFloat() {
        return new NormalPlaneF(new Vec3f(this.origin), new Vec3f(this.normal));
    }
}

