/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.tree;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHold;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiLabelHover;
import team.creative.creativecore.common.gui.control.tree.GuiTree;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.type.itr.FilterIterator;

public class GuiTreeItem
extends GuiParent {
    public final GuiTree tree;
    private GuiTreeItem parentItem;
    private final List<GuiTreeItem> items = new ArrayList<GuiTreeItem>();
    private int level = 0;
    private boolean open = true;
    private boolean selected = false;
    private GuiCheckBox checkbox;
    private final GuiLabel label;
    private GuiButton button;
    protected boolean moving = false;

    public GuiTreeItem(IGuiParent parent, String name, GuiTree tree) {
        super(parent, name);
        this.tree = tree;
        if (tree.hasCheckboxes()) {
            this.add((GuiControl)this.getOrCreateCheckbox());
        }
        this.label = new GuiLabelHover(parent, "title");
        this.add((GuiControl)this.label);
        this.setFlow(GuiFlow.STACK_X);
        this.setSpacing(5);
    }

    public GuiTreeItem setTranslate(String translate) {
        this.label.setTranslate(translate);
        return this;
    }

    public GuiTreeItem setTitle(class_2561 component) {
        this.label.setTitle(component);
        return this;
    }

    public GuiTreeItem setTitle(List<class_2561> components) {
        this.label.setTitle(components);
        return this;
    }

    public void resetCheckboxPartial() {
        if (this.checkbox != null) {
            this.checkbox.setPartial(false);
        }
    }

    protected GuiCheckBox getOrCreateCheckbox() {
        if (this.checkbox != null) {
            return this.checkbox;
        }
        this.checkbox = new GuiCheckBox(this, "box", true).consumeChanged(x -> {
            if (this.parentItem != null && this.tree.hasCheckboxesPartial()) {
                this.parentItem.childCheckedChanged((boolean)x);
            }
            this.setChecked((boolean)x);
        });
        return this.checkbox;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public boolean opened() {
        return this.open;
    }

    public void toggle() {
        if (this.button != null) {
            this.open = !this.open;
            this.button.setTitle((class_2561)class_2561.method_43470((String)(this.open ? "-" : "+")));
            this.tree.updateTree();
        }
    }

    public boolean isAtLeastPartiallyChecked() {
        return this.checkbox != null && (this.checkbox.get() || this.checkbox.getPartial());
    }

    public boolean isChecked() {
        return this.checkbox != null && this.checkbox.get();
    }

    protected void setChecked(boolean value) {
        if (this.checkbox != null) {
            this.checkbox.set(value);
            this.checkbox.setPartial(false);
        }
        if (this.tree.hasCheckboxesPartial()) {
            for (GuiTreeItem item : this.items) {
                item.setChecked(value);
            }
        }
    }

    protected void childCheckedChanged(boolean value) {
        if (this.checkbox == null) {
            return;
        }
        if (this.checkbox.get()) {
            return;
        }
        if (value) {
            if (this.checkbox.getPartial()) {
                return;
            }
            this.checkbox.setPartial(true);
            if (this.parentItem != null) {
                this.parentItem.childCheckedChanged(true);
            }
        } else {
            if (!this.checkbox.getPartial()) {
                return;
            }
            for (GuiTreeItem item : this.items) {
                if (!item.isAtLeastPartiallyChecked()) continue;
                return;
            }
            this.checkbox.setPartial(false);
            if (this.parentItem != null) {
                this.parentItem.childCheckedChanged(false);
            }
        }
    }

    protected void updateControls() {
        if (this.tree.hasCheckboxes() == (this.checkbox != null) && this.items.isEmpty() == (this.button == null)) {
            return;
        }
        this.clear();
        if (this.items.isEmpty()) {
            this.button = null;
        } else {
            this.button = (GuiButton)new GuiButtonHold(this, "expand", x -> this.toggle()).setTitle((class_2561)class_2561.method_43470((String)"-")).setFormatting(ControlFormatting.TRANSPARENT);
            this.add((GuiControl)this.button);
        }
        if (this.tree.hasCheckboxes()) {
            this.add((GuiControl)this.getOrCreateCheckbox());
        } else if (this.checkbox != null) {
            this.checkbox = null;
        }
        this.add((GuiControl)this.label);
    }

    public GuiTreeItem getParentItem() {
        return this.parentItem;
    }

    public void clearItems() {
        for (GuiTreeItem item : this.items) {
            item.parentItem = null;
            item.removed();
            this.updateControls();
        }
        this.items.clear();
    }

    public boolean removeItem(GuiTreeItem item) {
        if (this.items.remove(item)) {
            item.parentItem = null;
            item.removed();
            this.updateControls();
            return true;
        }
        return false;
    }

    public void removed() {
    }

    public void insertItemAfter(GuiTreeItem before, GuiTreeItem item) {
        this.insertItemAfter(this.indexOf(before), item);
    }

    public void insertItemAfter(int index, GuiTreeItem item) {
        item.parentItem = this;
        item.updateLevel();
        this.items.add(index + 1, item);
        item.added();
        this.updateControls();
    }

    public void insertItem(GuiTreeItem before, GuiTreeItem item) {
        this.insertItem(this.indexOf(before), item);
    }

    public void insertItem(int index, GuiTreeItem item) {
        item.parentItem = this;
        item.updateLevel();
        this.items.add(index, item);
        item.added();
        this.updateControls();
    }

    public void addItem(GuiTreeItem item) {
        item.parentItem = this;
        item.updateLevel();
        this.items.add(item);
        item.added();
        this.updateControls();
    }

    public void added() {
    }

    protected void updateLevel() {
        this.level = this.parentItem.level + 1;
        for (GuiTreeItem item : this.items) {
            item.updateLevel();
        }
    }

    public int getLevel() {
        return this.level;
    }

    public Iterable<GuiTreeItem> items() {
        return this.items;
    }

    public Iterable<GuiTreeItem> itemsChecked() {
        return new FilterIterator<GuiTreeItem>(this.items, GuiTreeItem::isAtLeastPartiallyChecked);
    }

    public GuiTreeItem getItem(int index) {
        return this.items.get(index);
    }

    public int indexOf(GuiTreeItem item) {
        return this.items.indexOf(item);
    }

    public int itemsCount() {
        return this.items.size();
    }

    public boolean isChild(GuiTreeItem item) {
        for (GuiTreeItem child : this.items) {
            if (child != item && !child.isChild(item)) continue;
            return true;
        }
        return false;
    }

    public boolean selected() {
        return this.selected;
    }

    protected void select() {
        this.selected = true;
        this.updateColor();
    }

    protected void deselect() {
        this.selected = false;
        this.updateColor();
    }

    protected void updateColor() {
        if (this.selected) {
            this.label.setDefaultColor(-256);
        } else {
            this.label.setDefaultColor(-1);
        }
    }
}

