/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pbr.texture;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.mixin.texture.SpriteContentsAnimatedTextureAccessor;
import net.irisshaders.iris.mixin.texture.SpriteContentsFrameInfoAccessor;
import net.irisshaders.iris.mixin.texture.SpriteContentsTickerAccessor;
import net.irisshaders.iris.pbr.loader.AtlasPBRLoader;
import net.irisshaders.iris.pbr.texture.PBRAtlasHolder;
import net.irisshaders.iris.pbr.texture.PBRDumpable;
import net.irisshaders.iris.pbr.texture.PBRType;
import net.irisshaders.iris.pbr.texture.TextureAtlasExtension;
import net.irisshaders.iris.pbr.util.TextureManipulationUtil;
import net.irisshaders.iris.platform.IrisPlatformHelpers;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_12137;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class PBRAtlasTexture
extends class_1044
implements PBRDumpable {
    protected final class_1059 atlasTexture;
    protected final PBRType type;
    protected final class_2960 location;
    private List<AtlasPBRLoader.PBRTextureAtlasSprite> sprites = List.of();
    protected final Map<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite> texturesByNameToAdd = new HashMap<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite>();
    protected Map<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite> texturesByName = new HashMap<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite>();
    private List<class_7764.class_12298> animatedTexturesStates = List.of();
    protected int width;
    protected int height;
    private GpuBuffer spriteUbos;
    private int mipLevelCount;
    private GpuTextureView[] mipViews = new GpuTextureView[0];
    private int maxMipLevel;
    private class_1058 missingSprite;

    public PBRAtlasTexture(class_1059 atlasTexture, PBRType type) {
        this.atlasTexture = atlasTexture;
        this.type = type;
        this.location = class_2960.method_60655((String)atlasTexture.method_24106().method_12836(), (String)(atlasTexture.method_24106().method_12832().replace(".png", "") + type.getSuffix() + ".png"));
    }

    public static void syncAnimation(class_7764.class_5790 source, class_7764.class_12298 target) {
        int time;
        SpriteContentsTickerAccessor sourceAccessor = (SpriteContentsTickerAccessor)source;
        List<class_7764.class_5791> sourceFrames = ((SpriteContentsAnimatedTextureAccessor)sourceAccessor.getAnimationInfo()).getFrames();
        int ticks = 0;
        for (int f = 0; f < sourceAccessor.getFrame(); ++f) {
            ticks += ((SpriteContentsFrameInfoAccessor)sourceFrames.get(f)).getTime();
        }
        SpriteContentsTickerAccessor targetAccessor = (SpriteContentsTickerAccessor)target;
        List<class_7764.class_5791> targetFrames = ((SpriteContentsAnimatedTextureAccessor)targetAccessor.getAnimationInfo()).getFrames();
        int cycleTime = 0;
        int frameCount = targetFrames.size();
        for (class_7764.class_5791 frame : targetFrames) {
            cycleTime += ((SpriteContentsFrameInfoAccessor)frame).getTime();
        }
        ticks %= cycleTime;
        int targetFrame = 0;
        while (ticks >= (time = ((SpriteContentsFrameInfoAccessor)targetFrames.get(targetFrame)).getTime())) {
            ++targetFrame;
            ticks -= time;
        }
        targetAccessor.setFrame(targetFrame);
        targetAccessor.setSubFrame(ticks + sourceAccessor.getSubFrame());
    }

    protected static void dumpSpriteNames(Path dir, String fileName, Map<class_2960, AtlasPBRLoader.PBRTextureAtlasSprite> sprites) {
        Path path = dir.resolve(fileName + ".txt");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Map.Entry entry : sprites.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                AtlasPBRLoader.PBRTextureAtlasSprite sprite = (AtlasPBRLoader.PBRTextureAtlasSprite)((Object)entry.getValue());
                writer.write(String.format(Locale.ROOT, "%s\tx=%d\ty=%d\tw=%d\th=%d%n", entry.getKey(), sprite.method_35806(), sprite.method_35807(), sprite.method_45851().method_45807(), sprite.method_45851().method_45815()));
            }
        }
        catch (IOException e) {
            Iris.logger.warn("Failed to write file {}", path, e);
        }
    }

    public PBRType getType() {
        return this.type;
    }

    public class_2960 getAtlasId() {
        return this.location;
    }

    public void addSprite(AtlasPBRLoader.PBRTextureAtlasSprite sprite) {
        this.texturesByNameToAdd.put(sprite.method_45851().method_45816(), sprite);
    }

    @Nullable
    public AtlasPBRLoader.PBRTextureAtlasSprite getSprite(class_2960 id) {
        return this.texturesByName.get(id);
    }

    public boolean tryUpload(int atlasWidth, int atlasHeight, int mipLevel) {
        try {
            this.upload(atlasWidth, atlasHeight, mipLevel);
            return true;
        }
        catch (Throwable t) {
            if (IrisPlatformHelpers.getInstance().isDevelopmentEnvironment()) {
                t.printStackTrace();
            }
            return false;
        }
    }

    private void createTexture(int i, int j, int k) {
        Iris.logger.info("Created: {}x{}x{} {}-atlas", i, j, k, this.location);
        GpuDevice gpuDevice = RenderSystem.getDevice();
        this.close();
        this.field_56974 = gpuDevice.createTexture(() -> ((class_2960)this.location).toString(), 15, TextureFormat.RGBA8, i, j, 1, k + 1);
        this.field_60597 = gpuDevice.createTextureView(this.field_56974);
        this.width = i;
        this.height = j;
        this.maxMipLevel = k;
        this.mipLevelCount = k + 1;
        this.mipViews = new GpuTextureView[this.mipLevelCount];
        TextureManipulationUtil.fillWithColor(this.field_56974.iris$getGlId(), this.maxMipLevel, this.type.getDefaultValue());
        for (int l = 0; l <= this.maxMipLevel; ++l) {
            this.mipViews[l] = gpuDevice.createTextureView(this.field_56974, l, 1);
        }
    }

    public void clearTextureData() {
        this.sprites.forEach(class_1058::close);
        this.sprites = List.of();
        this.animatedTexturesStates = List.of();
        this.texturesByName = Map.of();
        this.missingSprite = null;
    }

    public void upload(int atlasWidth, int atlasHeight, int mipLevel) {
        this.createTexture(atlasWidth, atlasHeight, mipLevel);
        this.clearTextureData();
        this.field_63613 = RenderSystem.getSamplerCache().method_75294(FilterMode.NEAREST);
        this.texturesByName = Map.copyOf(this.texturesByNameToAdd);
        this.missingSprite = null;
        ArrayList<AtlasPBRLoader.PBRTextureAtlasSprite> sprites = new ArrayList<AtlasPBRLoader.PBRTextureAtlasSprite>();
        ArrayList<class_7764.class_12298> animationStates = new ArrayList<class_7764.class_12298>();
        int animatedSpriteCount = (int)this.texturesByName.values().stream().filter(class_1058::method_76321).count();
        int spriteUboSize = class_3532.method_28139((int)class_7764.field_64235, (int)RenderSystem.getDevice().getUniformOffsetAlignment());
        int uboBlockSize = spriteUboSize * this.mipLevelCount;
        ByteBuffer spriteUboBuffer = MemoryUtil.memAlloc((int)(animatedSpriteCount * uboBlockSize));
        int animationIndex = 0;
        for (class_1058 class_10582 : this.texturesByName.values()) {
            if (!class_10582.method_76321()) continue;
            class_10582.method_76320(spriteUboBuffer, animationIndex * uboBlockSize, this.maxMipLevel, this.width, this.height, spriteUboSize);
            ++animationIndex;
        }
        GpuBuffer spriteUbos = animationIndex > 0 ? RenderSystem.getDevice().createBuffer(() -> String.valueOf(this.location) + " sprite UBOs", 128, spriteUboBuffer) : null;
        animationIndex = 0;
        for (AtlasPBRLoader.PBRTextureAtlasSprite spritex : this.texturesByName.values()) {
            sprites.add(spritex);
            if (!spritex.method_76321() || spriteUbos == null) continue;
            class_7764.class_12298 animationState = spritex.method_76319(spriteUbos.slice((long)(animationIndex * uboBlockSize), (long)uboBlockSize), spriteUboSize);
            ++animationIndex;
            if (animationState == null) continue;
            animationStates.add(animationState);
        }
        this.spriteUbos = spriteUbos;
        this.sprites = sprites;
        this.animatedTexturesStates = List.copyOf(animationStates);
        this.uploadInitialContents();
        if (class_155.field_29681) {
            Path path = TextureUtil.getDebugTexturePath();
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                this.method_49712(this.location, path);
            }
            catch (IOException var13) {
                Iris.logger.warn("Failed to dump atlas contents to {}", path);
            }
        }
        PBRAtlasHolder pBRAtlasHolder = ((TextureAtlasExtension)this.atlasTexture).getOrCreatePBRHolder();
        switch (this.type) {
            case NORMAL: {
                pBRAtlasHolder.setNormalAtlas(this);
                break;
            }
            case SPECULAR: {
                pBRAtlasHolder.setSpecularAtlas(this);
            }
        }
    }

    private void uploadInitialContents() {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        int spriteUboSize = class_3532.method_28139((int)class_7764.field_64235, (int)RenderSystem.getDevice().getUniformOffsetAlignment());
        int uboBlockSize = spriteUboSize * this.mipLevelCount;
        class_12137 gpuSampler = RenderSystem.getSamplerCache().method_75294(FilterMode.NEAREST);
        List<AtlasPBRLoader.PBRTextureAtlasSprite> staticSprites = this.sprites.stream().filter(textureAtlasSprite -> !textureAtlasSprite.method_76321()).toList();
        ArrayList<GpuTextureView[]> scratchTextures = new ArrayList<GpuTextureView[]>();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(staticSprites.size() * uboBlockSize));
        for (int k = 0; k < staticSprites.size(); ++k) {
            class_1058 textureAtlasSprite2 = staticSprites.get(k);
            textureAtlasSprite2.method_76320(byteBuffer, k * uboBlockSize, this.maxMipLevel, this.width, this.height, spriteUboSize);
            GpuTexture gpuTexture = gpuDevice.createTexture(() -> textureAtlasSprite2.method_45851().method_45816().toString(), 5, TextureFormat.RGBA8, textureAtlasSprite2.method_45851().method_45807(), textureAtlasSprite2.method_45851().method_45815(), 1, this.mipLevelCount);
            GpuTextureView[] gpuTextureViews = new GpuTextureView[this.mipLevelCount];
            for (int l = 0; l <= this.maxMipLevel; ++l) {
                textureAtlasSprite2.method_4584(gpuTexture, l);
                gpuTextureViews[l] = gpuDevice.createTextureView(gpuTexture);
            }
            scratchTextures.add(gpuTextureViews);
        }
        try (GpuBuffer gpuBuffer = gpuDevice.createBuffer(() -> "SpriteAnimationInfo", 128, byteBuffer);){
            for (int level = 0; level < this.mipLevelCount; ++level) {
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Animate " + String.valueOf(this.location), this.mipViews[level], OptionalInt.empty());){
                    renderPass.setPipeline(class_10799.field_64220);
                    for (int n = 0; n < staticSprites.size(); ++n) {
                        renderPass.bindTexture("Sprite", ((GpuTextureView[])scratchTextures.get(n))[level], gpuSampler);
                        renderPass.setUniform("SpriteAnimationInfo", gpuBuffer.slice((long)(n * uboBlockSize + level * spriteUboSize), (long)class_7764.field_64235));
                        renderPass.draw(0, 6);
                    }
                    continue;
                }
            }
        }
        Iterator iterator = scratchTextures.iterator();
        while (iterator.hasNext()) {
            GpuTextureView[] views;
            for (GpuTextureView view : views = (GpuTextureView[])iterator.next()) {
                view.close();
                view.texture().close();
            }
        }
        MemoryUtil.memFree((Buffer)byteBuffer);
    }

    public void cycleAnimationFrames() {
        if (this.field_56974 != null) {
            for (class_7764.class_12298 animationState : this.animatedTexturesStates) {
                animationState.method_76307();
            }
            if (this.animatedTexturesStates.stream().anyMatch(class_7764.class_12298::method_76310)) {
                for (int i = 0; i <= this.maxMipLevel; ++i) {
                    try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Animate " + String.valueOf(this.location), this.mipViews[i], OptionalInt.empty());){
                        for (class_7764.class_12298 animationState2 : this.animatedTexturesStates) {
                            if (!animationState2.method_76310()) continue;
                            animationState2.method_76309(renderPass, animationState2.method_76308(i));
                        }
                        continue;
                    }
                }
            }
        }
    }

    public void close() {
        PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.atlasTexture).getPBRHolder();
        if (pbrHolder != null) {
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(null);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(null);
                }
            }
        }
        super.close();
        for (GpuTextureView gpuTextureView : this.mipViews) {
            gpuTextureView.close();
        }
        for (class_7764.class_12298 animationState : this.animatedTexturesStates) {
            animationState.close();
        }
        if (this.spriteUbos != null) {
            this.spriteUbos.close();
            this.spriteUbos = null;
        }
    }

    public void method_49712(class_2960 id, Path path) {
        String string = id.method_36181();
        TextureUtil.writeAsPNG((Path)path, (String)string, (GpuTexture)this.method_68004(), (int)this.maxMipLevel, i -> i);
        PBRAtlasTexture.dumpSpriteNames(path, string, this.texturesByName);
    }

    @Override
    public class_2960 getDefaultDumpLocation() {
        return this.location;
    }
}

